// PLEASE NOTE THAT A SPACE BETWEEN TWO WORDS IS TAKEN AS TWO SEPERATE
// WORDS. PLEASE KEEP THIS FILE CONSISTENT.
var portName_L = new Array();
var portName_U = new Array();

var l_index=0;
var u_index=0;

// For each Linux interface name in the boardparms.c file, add
// a corresponding Linux interface name and a user-friendly name
// of its equivalent that must be displayed on the WEB UI. It is
// best if the new inteface names are added at the end.

// Wireless interfac Linux interface name
portName_L[l_index++]    = 'wl0';
// Wireless interface user-friendly name
portName_U[u_index++]     = 'Wireless';

// USB interface Linux interface name
portName_L[l_index++]    = 'usb0';
// USB user-friendly name
portName_U[u_index++]    = 'USB';

// Board ID 96338SV Linux name
portName_L[l_index++]     = '96338SV|eth0';
// Board ID 96338SV user-friendly name
portName_U[u_index++]     = '96338SV|ENET';

//Board ID 96338L-2M-8M Linux name
portName_L[l_index++]     = '96338L-2M-8M|eth0';
//Board ID 96338L-2M-8M user-friendly name
portName_U[u_index++]     = '96338L-2M-8M|ENET';

// Board ID 96348R Linux name
portName_L[l_index++]    = '96348R|eth0';
// Board ID 96348R user-friendly name
portName_U[u_index++]    = '96348R|ENET';

// Board ID 96348LV Linux name
portName_L[l_index++]    = '96348LV|eth0';
portName_L[l_index++]    = '96348LV|eth1';
// Board ID 96348LV user-friendly name
portName_U[u_index++]    = '96348LV|ENET1';
portName_U[u_index++]    = '96348LV|ENET2';

//Board ID RTA1320 Linux name
portName_L[l_index++]    = 'RTA1320|eth0';
// Board ID RTA1320 user-friendly names
portName_U[u_index++]    = 'RTA1320|Ethernet';

//Board ID RTA1380 Linux name
portName_L[l_index++]    = 'RTA1380|eth0';
// Board ID RTA1320 user-friendly names
portName_U[u_index++]    = 'RTA1380|Ethernet';

//Board ID RTA1025W Linux name
portName_L[l_index++]    = 'RTA1025W_16|eth0';
portName_L[l_index++]    = 'RTA1025W_16|eth0.2';
portName_L[l_index++]    = 'RTA1025W_16|eth0.3';
portName_L[l_index++]    = 'RTA1025W_16|eth0.4';
portName_L[l_index++]    = 'RTA1025W_16|eth0.5';
// Board ID RTA1025W user-friendly names
portName_U[u_index++]    = 'RTA1025W_16|Ethernet';
portName_U[u_index++]    = 'RTA1025W_16|Ethernet.1';
portName_U[u_index++]    = 'RTA1025W_16|Ethernet.2';
portName_U[u_index++]    = 'RTA1025W_16|Ethernet.3';
portName_U[u_index++]    = 'RTA1025W_16|Ethernet.4';

//Board ID RTA1375W Linux name
portName_L[l_index++]    = 'RTA1375W_16M|eth0';
portName_L[l_index++]    = 'RTA1375W_16M|eth0.2';
portName_L[l_index++]    = 'RTA1375W_16M|eth0.3';
portName_L[l_index++]    = 'RTA1375W_16M|eth0.4';
portName_L[l_index++]    = 'RTA1375W_16M|eth0.5';
//// Board ID RTA1375W user-friendly names
portName_U[u_index++]    = 'RTA1375W_16M|Ethernet';
portName_U[u_index++]    = 'RTA1375W_16M|Ethernet.1';
portName_U[u_index++]    = 'RTA1375W_16M|Ethernet.2';
portName_U[u_index++]    = 'RTA1375W_16M|Ethernet.3';
portName_U[u_index++]    = 'RTA1375W_16M|Ethernet.4';

//Board ID RTA1375 Linux name
portName_L[l_index++]    = 'RTA1375_16M|eth0';
portName_L[l_index++]    = 'RTA1375_16M|eth0.2';
portName_L[l_index++]    = 'RTA1375_16M|eth0.3';
portName_L[l_index++]    = 'RTA1375_16M|eth0.4';
portName_L[l_index++]    = 'RTA1375_16M|eth0.5';
////// Board ID RTA1375 user-friendly names
portName_U[u_index++]    = 'RTA1375_16M|Ethernet';
portName_U[u_index++]    = 'RTA1375_16M|Ethernet.1';
portName_U[u_index++]    = 'RTA1375_16M|Ethernet.2';
portName_U[u_index++]    = 'RTA1375_16M|Ethernet.3';
portName_U[u_index++]    = 'RTA1375_16M|Ethernet.4';

//Board ID RTA1320_16M Linux name
portName_L[l_index++]    = 'RTA1320_16M|eth0';
portName_L[l_index++]    = 'RTA1320_16M|eth0.2';
portName_L[l_index++]    = 'RTA1320_16M|eth0.3';
portName_L[l_index++]    = 'RTA1320_16M|eth0.4';
portName_L[l_index++]    = 'RTA1320_16M|eth0.5';
////// Board ID RTA1320_16M user-friendly names
portName_U[u_index++]    = 'RTA1320_16M|Ethernet';
portName_U[u_index++]    = 'RTA1320_16M|Ethernet.1';
portName_U[u_index++]    = 'RTA1320_16M|Ethernet.2';
portName_U[u_index++]    = 'RTA1320_16M|Ethernet.3';
portName_U[u_index++]    = 'RTA1375_16M|Ethernet.4';

// Board ID RTA1415W Linux name
portName_L[l_index++]    = 'RTA1415W|eth0';
portName_L[l_index++]    = 'RTA1415W|eth0.2';
portName_L[l_index++]    = 'RTA1415W|eth0.3';
portName_L[l_index++]    = 'RTA1415W|eth0.4';
portName_L[l_index++]    = 'RTA1415W|eth0.5';
// Board ID RTA1415W user-friendly names
portName_U[u_index++]    = 'RTA1415W|Ethernet';
portName_U[u_index++]    = 'RTA1415W|Ethernet.1';
portName_U[u_index++]    = 'RTA1415W|Ethernet.2';
portName_U[u_index++]    = 'RTA1415W|Ethernet.3';
portName_U[u_index++]    = 'RTA1415W|Ethernet.4';

// Board ID RTA1427W Linux name
portName_L[l_index++]    = 'RTA1427W|eth0';
portName_L[l_index++]    = 'RTA1427W|eth0.2';
portName_L[l_index++]    = 'RTA1427W|eth0.3';
portName_L[l_index++]    = 'RTA1427W|eth0.4';
portName_L[l_index++]    = 'RTA1427W|eth0.5';
// // Board ID RTA1427W user-friendly names
portName_U[u_index++]    = 'RTA1427W|Ethernet';
portName_U[u_index++]    = 'RTA1427W|Ethernet.1';
portName_U[u_index++]    = 'RTA1427W|Ethernet.2';
portName_U[u_index++]    = 'RTA1427W|Ethernet.3';
portName_U[u_index++]    = 'RTA1427W|Ethernet.4';

// Board ID RTA1405VW Linux name
portName_L[l_index++]    = 'RTA1405VW|eth0';
portName_L[l_index++]    = 'RTA1405VW|eth0.2';
portName_L[l_index++]    = 'RTA1405VW|eth0.3';
portName_L[l_index++]    = 'RTA1405VW|eth0.4';
portName_L[l_index++]    = 'RTA1405VW|eth0.5';
// Board ID RTA1405VW user-friendly names
portName_U[u_index++]    = 'RTA1405VW|Ethernet';
portName_U[u_index++]    = 'RTA1405VW|Ethernet.1';
portName_U[u_index++]    = 'RTA1405VW|Ethernet.2';
portName_U[u_index++]    = 'RTA1405VW|Ethernet.3';
portName_U[u_index++]    = 'RTA1405VW|Ethernet.4';

// Board ID RTA1425VW Linux name
portName_L[l_index++]    = 'RTA1425VW|eth1';
portName_L[l_index++]    = 'RTA1425VW|eth1.2';
portName_L[l_index++]    = 'RTA1425VW|eth1.3';
portName_L[l_index++]    = 'RTA1425VW|eth1.4';
portName_L[l_index++]    = 'RTA1425VW|eth1.5';
// Board ID RTA1425VW user-friendly names
portName_U[u_index++]    = 'RTA1425VW|Ethernet';
portName_U[u_index++]    = 'RTA1425VW|Ethernet.1';
portName_U[u_index++]    = 'RTA1425VW|Ethernet.2';
portName_U[u_index++]    = 'RTA1425VW|Ethernet.3';
portName_U[u_index++]    = 'RTA1425VW|Ethernet.4';


// Board ID RTV1505VW Linux name
portName_L[l_index++]    = 'RTV1505VW|eth0';
portName_L[l_index++]    = 'RTV1505VW|eth0.2';
portName_L[l_index++]    = 'RTV1505VW|eth0.3';
portName_L[l_index++]    = 'RTV1505VW|eth0.4';
portName_L[l_index++]    = 'RTV1505VW|eth0.5';
// Board ID RTV1505VW user-friendly names
portName_U[u_index++]    = 'RTV1505VW|Ethernet';
portName_U[u_index++]    = 'RTV1505VW|Ethernet.1';
portName_U[u_index++]    = 'RTV1505VW|Ethernet.2';
portName_U[u_index++]    = 'RTV1505VW|Ethernet.3';
portName_U[u_index++]    = 'RTV1505VW|Ethernet.4';

//Board ID RTV1610 Linux name
portName_L[l_index++]    = 'RTV1610|eth0';
portName_L[l_index++]    = 'RTV1610|eth1';
portName_L[l_index++]    = 'RTV1610|eth2';
portName_L[l_index++]    = 'RTV1610|eth3';
portName_L[l_index++]    = 'RTV1610|eth4';
// Board ID RTV1610 user-friendly names
portName_U[u_index++]    = 'RTV1610|LAN1';
portName_U[u_index++]    = 'RTV1610|LAN2';
portName_U[u_index++]    = 'RTV1610|LAN3';
portName_U[u_index++]    = 'RTV1610|LAN4';
portName_U[u_index++]    = 'RTV1610|LAN5';

// Board ID RTV1605W Linux name
portName_L[l_index++]    = 'RTV1605W|eth0';
portName_L[l_index++]    = 'RTV1605W|eth1';
portName_L[l_index++]    = 'RTV1605W|eth2';
portName_L[l_index++]    = 'RTV1605W|eth3';
portName_L[l_index++]    = 'RTV1605W|eth4';
// Board ID RTV1605W user-friendly names
portName_U[u_index++]    = 'RTV1605W|LAN1';
portName_U[u_index++]    = 'RTV1605W|LAN2';
portName_U[u_index++]    = 'RTV1605W|LAN3';
portName_U[u_index++]    = 'RTV1605W|LAN4';
portName_U[u_index++]    = 'RTV1605W|LAN5';

// Board ID RTV1605VW2 Linux name
 portName_L[l_index++]    = 'RTV1605VW2|eth0';
 portName_L[l_index++]    = 'RTV1605VW2|eth1';
 portName_L[l_index++]    = 'RTV1605VW2|eth2';
 portName_L[l_index++]    = 'RTV1605VW2|eth3';
 portName_L[l_index++]    = 'RTV1605VW2|eth4';
 // Board ID RT1605VW2 user-friendly names
 portName_U[u_index++]    = 'RTV1605VW2|LAN1';
 portName_U[u_index++]    = 'RTV1605VW2|LAN2';
 portName_U[u_index++]    = 'RTV1605VW2|LAN3';
 portName_U[u_index++]    = 'RTV1605VW2|LAN4';
 portName_U[u_index++]    = 'RTV1605VW2|LAN5';


function getUNameByLName(name) {
   var index = 0;
   var uName   = '';
   // SafetyNet if someone sends a name without prefixing the
   // board ID and |, then return that name.
   if (name.indexOf('|') == -1)
      return name;
      
   /*Wlan naming: Could be a better name*/
   if (name.indexOf('wl0.3') != -1) {
      return 'Wireless.4';
   }
   else if (name.indexOf('wl0.2') != -1) {
      return 'Wireless.3';
   }
   else if (name.indexOf('wl0.1') != -1) {
      return 'Wireless.2';
   }
   else if (name.indexOf('wl0') != -1) {
      return 'Wireless';
   }
    else if (name.indexOf('wl1.3') != -1) {
      return 'wl1_Guest3';
   }
    else if (name.indexOf('wl1.2') != -1) {
      return 'wl1_Guest2';
   }
    else if (name.indexOf('wl1.1') != -1) {
      return 'wl1_Guest1';
   }
    else if (name.indexOf('wl1') != -1) {
      return 'wlan1';
   }

   if (name.indexOf('usb0') != -1) {
      return 'USB';
   }
   for (index = 0; index < portName_L.length; index++) {
      if (portName_L[index] == name) {
         uName = portName_U[index].split('|');
         return uName[1];
      }
   }
   uName = name.split('|');
   return uName[1];
}

function getLNameByUName(name) {
   var index = 0;
   var brdIntf = name.split('|');
   var lName   = '';
   var uName   = '';

   // SafetyNet if someone sends a name without prefixing the
   // board ID and |, then return that name.
   if (name.indexOf('|') == -1)
      return name;
      
   if (name.indexOf('Wireless.4') != -1)
      return 'wl0.3';
   if (name.indexOf('Wireless.3') != -1)
      return 'wl0.2';
   if (name.indexOf('Wireless.2') != -1)
      return 'wl0.1';
   if (name.indexOf('Wireless') != -1)
      return 'wl0';
   if (name.indexOf('wl1_Guest3') != -1)
      return 'wl1.3';
   if (name.indexOf('wl1_Guest2') != -1)
      return 'wl1.2';
   if (name.indexOf('wl1_Guest1') != -1)
      return 'wl1.1';
   if (name.indexOf('wlan1') != -1)
      return 'wl1';
      
   if (name.indexOf('USB') != -1)
      return 'usb0';
   for (index = 0; index < portName_U.length; index++) {
      uName = portName_U[index].split('|');
      if (portName_U[index] == name) {
         lName = portName_L[index].split('|');
         return lName[1];
      }
   }
   lName = name.split('|');
   return lName[1];
}

function conNameToserName(brIfName, brSerName){
	var temp3='';
	var temp4='';
	var j=0;
	temp3 = brSerName.split(', ');
	for (j = 0; j < temp3.length; j++) {
		temp4 = temp3[j].split('|');
		if (brIfName == temp4[0]){
			return temp4[1];
		}
	}
	return brIfName;
}

function transNastoBr(name){
	var temp='';
	if (name.indexOf('nas',0)!=-1){
		temp = name.substr(3,name.length);
		name='br'+temp;
		return name;
	} else {
		return temp;
	}
}
